package gov.va.med.mhv.vitals.repository;

import gov.va.med.mhv.vitals.model.LipidsReading;

import java.util.List;

import org.springframework.data.domain.Pageable;
import org.springframework.data.jpa.repository.JpaRepository;
import org.springframework.data.jpa.repository.Query;
import org.springframework.data.repository.query.Param;

public interface LipidsReadingRepository extends JpaRepository<LipidsReading, Long>{
	
	 @Query("select a from LipidsReading a where a.userprofileId = :userprofileid order by a.reading desc")
	 List<LipidsReading>  getLipidsReadingsForUser(@Param ("userprofileid") Long userprofileid);
	 
	 
	 @Query("select a from LipidsReading a where a.userprofileId = :userprofileid order by a.reading desc")
	 List<LipidsReading>  getDashBoardLipidsReadingsForUser(@Param ("userprofileid") Long userprofileid,Pageable page);



}
